/** @file   menusettings.h
 * @brief   Declaration of MenuSettings - class.
 * @version $Revision: 1.2 $
 * @author  Tomi Lamminsaari
 */
 
#ifndef H_WWW_MENUSETTINGS_H
#define H_WWW_MENUSETTINGS_H

#include "menupage.h"
#include "Font.h"
#include "Gradient.h"
#include "Sprite.h"


namespace WeWantWar {


/** @class  MenuSettings
 * @brief   Does the settings - menu
 * @author    Tomi Lamminsaari
 *
 * The SETTINGS - menu is an instance of this class.
 */
class MenuSettings : public MenuPage
{
public:

  ///
  /// Static members and methods
  /// ==========================
  
  /** Index of the BACK-TO-MAINMENU - option */
  static const int BACK_TO_MAINMENU;


  ///
  /// Constructors, destructor and operators
  /// ======================================

  /** Constructor.
   */
  MenuSettings();
  
  /** Destructor.
   */
  virtual ~MenuSettings();
  


  ///
  /// Public methods
  /// ==============
  
  /** Updates the menupage.
   * @return    Either @c MenuPage::NO_PAGE_CHANGE or @c MenuPage::PAGE_CHANGE
   */
  virtual int update();
  
  /** Draws this menupage.
   */
  virtual void redraw();
  


  ///
  /// Public GET-methods
  /// ==================
  
  /** Returns the id of this page.
   * @return    <code>MenuPage::SETTINGS</code>
   */
  virtual MenuPage::PageID getPageID() const { return MenuPage::SETTINGS; }
  
protected:

  /** Builds the help notes
   */
  void createHelpNotes();
  
  /** Handles the situation when player pressed enter/space.
   * @return    Either @c MenuPage::NO_PAGE_CHANGE or @c MenuPage::PAGE_CHANGE
   *            depeding on which option was selected when user pressed the
   *            selection key.
   */
  int checkEnterKey();
  
  /** Initializes the graphics.
   * @return    Nonzero if fails.
   */
  int initGraphics();
  
  /** Destroyes the graphics created by @c initGraphics() - method.
  */
  void cleanupGraphics();
  
  /** Updates the fade-in state.
   * @return    Either @c MenuPage::NO_PAGE_CHANGE or @c MenuPage::PAGE_CHANGE
   */
  int updateFadeInState();
  
  /** Updates the visible state
   * @return    Either @c MenuPage::NO_PAGE_CHANGE or @c MenuPage::PAGE_CHANGE
   */
  int updateVisibleState();
  
  /** Updates the fade-out state.
   * @return    Either @c MenuPage::NO_PAGE_CHANGE or @c MenuPage::PAGE_CHANGE
   */
  int updateFadeOutState();
  
  /** Updates the graphics of CONTROLLER - option.
   * @param     pB                Pointer to bitmap where the option should
   *                              be drawn.
   */
  void updateControllerBuffer( BITMAP* pB );
  
  /** Updates the graphics of INGAME MUSICS - option.
   * @param     pB                Pointer to bitmap where the option should
   *                              be drawn.
   */
  void updateMusicsBuffer( BITMAP* pB );
  
  /** Updates the graphics of START FROM LEVEL - option.
   * @param     pB                Pointer to bitmap where the option should
   *                              be drawn.
   */
  void updateStartFromBuffer( BITMAP* pB );
  
  /** Updates the graphics of DIFFICULTY - option
   * @param     pB                Pointer to bitmap
   */
  void updateDifficultyBuffer( BITMAP* pB );
  
  /** Updates the graphics of EXIT - option.
   * @param     pB                Pointer to bitmap where the option should
   *                              be drawn.
   */
  void updateExitBuffer( BITMAP* pB );
  
  /** Updates the graphics of all the menuoptions.
   */
  void updateSpriteBuffers();
  
  
  
  ///
  /// Members
  /// =======

  /** Each menuitem is an sprite and they are stored in this vector. */
  std::vector<eng2d::Sprite*> m_sprites;
  

  
private:

  MenuSettings(const MenuSettings& rO);
  MenuSettings& operator = (const MenuSettings& rO);
};


};  // end of namespace


#endif

/**
 * Version history
 * ===============
 * $Log: menusettings.h,v $
 * Revision 1.2  2006/08/20 21:12:09  lamminsa
 * no message
 *
 * Revision 1.1.1.1  2006/01/21 23:02:42  lamminsa
 * no message
 *
 * Revision 1.1  2005-11-13 14:33:36+02  lamminsa
 * include file changes.
 *
 */
 
